#ifndef _TRIANGLE_H_
#define _TRIANGLE_H_

#include "cvect.h"

/*
  c0
   c_   s3
   | --_
s1 |   _-c c2
   |_--
   c    s2
  c1
*/


class triangle {
public:
  triangle(void);
  triangle(cvect c1, cvect c2, cvect c3);

  void locate(cvect c1, cvect c2, cvect c3);
  void flip(int axis);
  int match(triangle& tri);
  bool link(triangle * tri);
  bool exposed(void);
  double area(void);
  cvect normal(void);
  void print(void);
  cvect corner[3];
  triangle * next, * side[3];

  ~triangle(void);
};

#endif //_TRIANGLE_H_
